﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data;
using System.Data.SqlClient;
using AZVIC.Ei8htPOS.Entities;
using AZVIC.Ei8htPOS.Utilities;

namespace AZVIC.Ei8htPOS.DAL
{
    public class ProductCategoryDB
    {
        public static ProductCategory GetItem(Guid productCategoryID, string keyword)
        {

            List<SqlParameter> parameters = new List<SqlParameter>();
            parameters.Add(new SqlParameter("@ProductCategoryID", ((productCategoryID != Guid.Empty && productCategoryID != null) ? productCategoryID : (object)DBNull.Value)));
            parameters.Add(new SqlParameter("@Keyword", (string.IsNullOrEmpty(keyword) ? (object)DBNull.Value : keyword)));

            return SQLHelper.RetrieveObject<ProductCategory>("spGetProductCategory", parameters);
        }

        public static List<ProductCategory> GetList(Guid productCategoryID, string keyword)
        {
            List<SqlParameter> parameters = new List<SqlParameter>();
            parameters.Add(new SqlParameter("@ProductCategoryID", ((productCategoryID != Guid.Empty && productCategoryID != null) ? productCategoryID : (object)DBNull.Value)));
            parameters.Add(new SqlParameter("@Keyword", (string.IsNullOrEmpty(keyword) ? (object)DBNull.Value : keyword)));

            return SQLHelper.RetrieveList<ProductCategory>("spGetProductCategory", parameters);
            
        }

        public static DataTable GetDataTable(Guid productCategoryID, string keyword)
        {
            List<SqlParameter> parameters = new List<SqlParameter>();
            parameters.Add(new SqlParameter("@ProductCategoryID", ((productCategoryID != Guid.Empty && productCategoryID != null) ? productCategoryID : (object)DBNull.Value)));
            parameters.Add(new SqlParameter("@Keyword", (string.IsNullOrEmpty(keyword) ? (object)DBNull.Value : keyword)));

            return SQLHelper.ExecuteDataTable("spGetProductCategory", parameters);
            
        }

        public static DataSet GetDataSet(Guid productCategoryID, string keyword)
        {
           List<SqlParameter> parameters = new List<SqlParameter>();
            parameters.Add(new SqlParameter("@ProductCategoryID", ((productCategoryID != Guid.Empty && productCategoryID != null) ? productCategoryID : (object)DBNull.Value)));
            parameters.Add(new SqlParameter("@Keyword", (string.IsNullOrEmpty(keyword) ? (object)DBNull.Value : keyword)));

            return SQLHelper.ExecuteDataSet("spGetProductCategory", parameters);
            
        }

        public static void Save(ProductCategory myProductCategory)
        {
            myProductCategory.Mode = ((myProductCategory.UniqueID != Guid.Empty && myProductCategory.UniqueID != null) ? GlobalConfigurations.Mode.Update : GlobalConfigurations.Mode.Insert);
            myProductCategory.UniqueID = ((myProductCategory.UniqueID != Guid.Empty && myProductCategory.UniqueID != null) ? myProductCategory.UniqueID : Guid.NewGuid());
            if (myProductCategory.Mode == GlobalConfigurations.Mode.Insert)
            {
                myProductCategory.IsActive = true;
            }

            List<SqlParameter> parameters = new List<SqlParameter>();
            parameters.Add(new SqlParameter("@ProductCategoryID", myProductCategory.UniqueID));
            parameters.Add(new SqlParameter("@CategoryName", (string.IsNullOrEmpty(myProductCategory.CategoryName) ? (object)DBNull.Value : myProductCategory.CategoryName)));
            parameters.Add(new SqlParameter("@SequenceNo", (myProductCategory.SequenceNo == 0) ? (object)DBNull.Value : myProductCategory.SequenceNo));
                //parameters.Add(new SqlParameter("@IsShowInShop", myProductCategory.IsShowInShop));
            parameters.Add(new SqlParameter("@CreatedBy", ((myProductCategory.UserAccountID != Guid.Empty && myProductCategory.UserAccountID != null) ? myProductCategory.UserAccountID : (object)DBNull.Value)));
            parameters.Add(new SqlParameter("@IsActive", myProductCategory.IsActive));
            //parameters.Add(new SqlParameter("@IsDeleted", myProductCategory.IsDeleted));
            parameters.Add(new SqlParameter("@Mode", myProductCategory.Mode));

            SQLHelper.ExecuteQuery("spAddOrUpdateProductCategory", parameters);
            
        }
    }
}
